#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "ctrl/BOLTControls.h"

#include "BOLTFrm.h"
/* definitions */
#include "wx/treectrl.h"

#include "wx/progdlg.h"

#define PROG_STEP 100
enum {
	ID_TREECTL = 36690,
		ID_NEWBUTTON,
		ID_SEARCHBUTTON,
		ID_OK=wxID_OK,
		ID_CANCEL=wxID_CANCEL
};

//IMPLEMENT_DYNAMIC_CLASS(BOLTChooser, wxDialog)
BEGIN_EVENT_TABLE(BOLTChooser, wxDialog)
EVT_TREE_SEL_CHANGED(ID_TREECTL,BOLTChooser::handleQueryList)
EVT_TREE_ITEM_EXPANDED(ID_TREECTL,BOLTChooser::handleQueryList)
EVT_TREE_ITEM_EXPANDING(ID_TREECTL,BOLTChooser::handleQueryList)
EVT_TREE_ITEM_COLLAPSED(ID_TREECTL,BOLTChooser::handleQueryList)
EVT_TREE_ITEM_ACTIVATED(ID_TREECTL,BOLTChooser::OnActivate)
EVT_BUTTON(ID_NEWBUTTON,BOLTChooser::OnBNew)
EVT_BUTTON(ID_SEARCHBUTTON,BOLTChooser::OnBSearch)
EVT_BUTTON(ID_OK,BOLTChooser::OnBOK)
EVT_BUTTON(ID_CANCEL,BOLTChooser::OnBCancel)
EVT_CLOSE(BOLTChooser::OnBCancel)
END_EVENT_TABLE()

BOLTChooser::BOLTChooser(BOLTdb *dbase,wxWindow* parent, 
		wxWindowID id, long style): wxDialog(parent,id,"Chooser",wxDefaultPosition,wxDefaultSize,style,"Chooser") 
{
#define DEFSPACE 1,wxEXPAND|wxALL,10
	db=dbase;
	SetFont(parent->GetFont());
	wxBoxSizer *tSizer=new wxBoxSizer(wxVERTICAL);
	wxBoxSizer *bSizer=new wxBoxSizer(wxHORIZONTAL);
	bOk=new wxButton(this,ID_OK,"Ch&oose");
	bSizer->Add(bOk,DEFSPACE);
	bSearch=new wxButton(this,ID_SEARCHBUTTON,"&Find...");
	bSizer->Add(bSearch,DEFSPACE);
	bNew = new wxButton(this,ID_NEWBUTTON,"&New        ");
	bSizer->Add(bNew,DEFSPACE);
	bCancel=new wxButton(this,ID_CANCEL,"&Cancel");
	bSizer->Add(bCancel,DEFSPACE);
	tSizer->Add(bSizer,0,wxALL|wxEXPAND,3);
	treeCtrl=new bcQueryList(db,this,ID_TREECTL,wxString("Quick Picks"));

	//	treeCtrl=new wxTreeCtrl(this,ID_TREECTL,wxDefaultPosition,wxDefaultSize);
	//	treeCtrl->AddRoot("Quick Pick");
	tSizer->Add(treeCtrl,1,wxALL|wxEXPAND,15);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(tSizer);
//	tSizer->Fit(this);
//	tSizer->SetSizeHints(this);
	SetSize(parent->GetSize());
	CenterOnParent();
	bOk->SetDefault();
	treeCtrl->SetFocus();
};

BOLTChooser::~BOLTChooser()
{
	treeCtrl->DeleteAllItems();
};

bool BOLTChooser::AddQuery(wxString& name,wxString& query)
{
	return treeCtrl->AddQuery(name,query);
};

bool BOLTChooser::AddQuery(const char *name,const char *query)
{
	wxString wName,wQry;
	wName.Printf("%s",name);
	wQry.Printf("%s",query);
	return AddQuery(wName,wQry);
}
	bool BOLTChooser::SetSearchFields(wxString& table,wxArrayString& fields)
{
		this->table=table;
		this->searchFields=fields;
		return TRUE;
};
	bool BOLTChooser::ClearQueries()
{

		treeCtrl->DeleteAllItems();
		treeCtrl->AddRoot("Quick Pick");
		return(TRUE);
};
RECORD_ID BOLTChooser::GetChoice(bool allowNew,const char *newTable, bool allowSearch)
{

	if (allowNew)
	{ this->table=newTable; }
	wxString nLbl;
	nLbl=this->table;
	nLbl.Prepend("&New ");

	bNew->SetLabel(nLbl.Left(nLbl.Length()-1));
	bNew->Show(allowNew);
	bSearch->Show(allowSearch&&(this->searchFields.Count()>0));
	Show(TRUE);
	return ShowModal();
};

RECORD_ID BOLTChooser::SearchChoice(const char *searchString)
{
	BOLTSearcher *searcher;
	searcher=new BOLTSearcher(this->db,this,-1);
	return(searcher->GetChoice(table,searchFields,searchString));
};

void BOLTChooser::OnActivate(wxTreeEvent& event)
{
		RECORD_ID recId;
		bcQueryList *ql;
		if (event.GetEventType()==wxEVT_COMMAND_TREE_KEY_DOWN)
		{ if (event.GetCode()!=WXK_RETURN) { event.Skip(); return; } }
		if (ql=(bcQueryList *)event.GetEventObject())
		{
			if(recId=ql->GetChoice())
			{
				EndModal(recId);
			} else { handleQueryList(event); }
		}
};

void BOLTChooser::OnBOK(wxCommandEvent& event)
{
	if (treeCtrl->GetChoice()!=0)
	{
		EndModal(treeCtrl->GetChoice());	
	} else { wxBell(); }
};

void BOLTChooser::OnBNew(wxCommandEvent& event)
{
	EndModal(db->NewRecord(table.c_str()));
};

void BOLTChooser::OnBSearch(wxCommandEvent& event)
{
	RECORD_ID sResult;
	BOLTSearcher *searcher;
	searcher=new BOLTSearcher(this->db,this,-1);
	sResult=searcher->GetChoice(table,searchFields);
	if (sResult)
	{ EndModal(sResult); }
};

void BOLTChooser::OnBCancel(wxCommandEvent& event)
{
	EndModal(0);	
};

void BOLTChooser::AddQuickPicks(const char *qpClass)
{
QRY_ID qry;
void *row;

wxString tStr,tQuery;
//	char *tmp;
//	RECORD_ID itemId;

tStr.Printf("select title,query from quickpicks where class='%s' order by title",qpClass);

qry=db->Query((char *)tStr.c_str(),tStr.Length());
if (qry==NULL)
{
	if (db->IsError()) { LOG_ERROR(db->GetError()); }
	return; 
}
while (row=db->FetchRow(qry))
{
	tStr=db->FetchQueryResult(qry,row,0);
	tQuery=db->FetchQueryResult(qry,row,1);
	if (!(tStr.IsEmpty()||tQuery.IsEmpty()))
	{
	treeCtrl->AddQuery(tStr,tQuery);
	}
}
db->FreeQuery(qry);
}

void BOLTChooser::handleQueryList(wxTreeEvent &event)
{

/*
	switch (event.GetEventType())
	{
		case wxEVT_COMMAND_TREE_ITEM_COLLAPSED:
			this->lTransactions->OnColapse(event);
		break;
		case wxEVT_COMMAND_TREE_ITEM_ACTIVATED:
//			this->lTransactions->OnExpand(event);
		break;
		case wxEVT_COMMAND_TREE_ITEM_EXPANDED:
		break;
		case wxEVT_COMMAND_TREE_ITEM_EXPANDING:
			this->lTransactions->OnExpand(event);
			event.Skip();
			break;
		case wxEVT_COMMAND_TREE_SEL_CHANGED:
		break;
	}
*/
	if (event.GetEventType()==wxEVT_COMMAND_TREE_ITEM_COLLAPSED)
	{ 	this->treeCtrl->OnColapse(event); }
	if (event.GetEventType()==wxEVT_COMMAND_TREE_ITEM_EXPANDING)
	{
		this->treeCtrl->OnExpand(event);
		event.Skip();
	}}

enum {
	ID_SEARCH=46666,
		ID_START,
		ID_CANCL=wxID_CANCEL,
		ID_OPEN=wxID_OK,
		ID_CASE,
		ID_WHOLE,
		ID_RESULT };
//#define ID_CANCL	wxID_CANCEL

//IMPLEMENT_DYNAMIC_CLASS(BOLTSearcher,wxDialog)
BEGIN_EVENT_TABLE(BOLTSearcher,wxDialog)
EVT_BUTTON(ID_START,BOLTSearcher::OnBStart)
EVT_BUTTON(ID_CANCL,BOLTSearcher::OnBCancel)
EVT_BUTTON(ID_OPEN,BOLTSearcher::OnBOpen)
EVT_CHECKBOX(ID_CASE,BOLTSearcher::OnCCase)
EVT_CHECKBOX(ID_WHOLE,BOLTSearcher::OnCWhole)
EVT_LIST_ITEM_ACTIVATED(ID_RESULT,BOLTSearcher::OnActivate)
EVT_LIST_COL_CLICK(ID_RESULT,BOLTSearcher::OnColumn)
EVT_TEXT(ID_SEARCH,BOLTSearcher::OnTSearch)
EVT_CLOSE(BOLTSearcher::OnBCancel)
EVT_CHAR(BOLTSearcher::OnChar)
END_EVENT_TABLE()

BOLTSearcher::BOLTSearcher(BOLTdb *dbase,wxWindow* parent,wxWindowID id,long style) :
 wxDialog(parent,id,"Chooser",wxDefaultPosition,wxDefaultSize,style,"Chooser") 
 {
	wxBoxSizer *topSizer;
	wxBoxSizer *tmpSizer;
	wxStaticBoxSizer *resSizer;
	db=dbase;
	lResults=NULL;
	SetFont(parent->GetFont());

//	sOrderBy="created DESC";
	sOrderBy="id DESC";
	topSizer=new wxBoxSizer(wxVERTICAL);
	tmpSizer=new wxBoxSizer(wxHORIZONTAL);
	//search label
	tmpSizer->Add(new wxStaticText(this,-1,"Search for "),0,wxALL,5);
	//search string
	tmpSizer->Add(tSearch=new wxTextCtrl(this,ID_SEARCH,""),1,wxALL,5);
	//start button
	topSizer->Add(tmpSizer,1,wxEXPAND);
	tmpSizer=new wxBoxSizer(wxHORIZONTAL);
	//checkboxes
	tmpSizer->Add(bStart=new wxButton(this,ID_START,"Start"),0,wxALL,5);
	tmpSizer->Add(bCancel=new wxButton(this,ID_CANCL,"Cancel"),0,wxALL,5);
	tmpSizer->Add(cCase=new wxCheckBox(this,ID_CASE,"Case Sensitive"),0,wxALL,5);
	tmpSizer->Add(cWhole=new wxCheckBox(this,ID_WHOLE,"Whole Word"),0,wxALL,5);
	//cancel button
	topSizer->Add(tmpSizer,1,wxEXPAND);
	resSizer = new wxStaticBoxSizer(new wxStaticBox(this,-1,"Results"),wxHORIZONTAL);
	resSizer->Add(bOpen=new wxButton(this,ID_OPEN,"Open"),0,wxALL,5);
	//results
	resSizer->Add(lResults=new wxListCtrl(this,ID_RESULT,wxDefaultPosition,wxDefaultSize,wxLC_REPORT |wxLC_HRULES|wxLC_SINGLE_SEL),4,wxEXPAND,5);
	//open button
	topSizer->Add(resSizer,8,wxEXPAND);
//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
//	topSizer->SetSizeHints(this);
//	topSizer->Fit(this);
	SetSize(parent->GetSize());
	CenterOnParent();
	this->cancelSearch=false;
	Show(TRUE);

 };

BOLTSearcher::~BOLTSearcher()
{ if (lResults) { lResults->ClearAll(); } };

RECORD_ID BOLTSearcher::GetChoice(wxString& table,wxArrayString& searchFields,const char *search)
{
	this->table=table;
	this->searchFields=searchFields;
	this->searchFields.Insert("ID",0);
//fill in lResults columns
	lResults->InsertColumn(0,"id",wxLIST_FORMAT_LEFT,wxLIST_AUTOSIZE);
	for (size_t i=0; i<searchFields.GetCount(); i++)
	{
		lResults->InsertColumn(i+1,searchFields[i],wxLIST_FORMAT_LEFT,wxLIST_AUTOSIZE);
	}
	bStart->Enable(FALSE);
	bOpen->Enable(FALSE);
	tSearch->SetFocus();

	if ((search)&&(strlen(search)>0))
	{
		tSearch->SetValue(search);
		DoSearch();
	}
	return(ShowModal());
}

void BOLTSearcher::OnActivate(wxListEvent& event)
{
	OnBOpen(wxCommandEvent(0,0));
	/*
	lResults->ClearAll();
	EndModal(event.GetData());
	*/
};

void BOLTSearcher::OnBStart(wxCommandEvent& event)
{
	DoSearch();
}

void BOLTSearcher::DoSearch()
{
QRY_ID qry;
char *tmp;
void *row;
wxString query,srch;
unsigned long i;
//size_t i;
bool isCode;
wxString codeField,codeTable,codeAlias,tStr;
wxString fromStr,whereStr;
int codeCnt=0;
wxProgressDialog  *prog;
wxBeginBusyCursor();
Enable(FALSE);
lResults->DeleteAllItems();
	//build query
	query="SELECT xxx.ID";
	prog=new wxProgressDialog("Getting Information","Building Question",2,this->GetParent(),wxPD_APP_MODAL);

	fromStr.Printf(" FROM %s xxx ",this->table);
	whereStr=" WHERE ";
	for (i=0; i<searchFields.GetCount(); i++)
	{
		isCode=searchFields[i].Contains(":");
		if (isCode)
		{
			codeAlias.Printf("c%d",codeCnt++);
			codeField=searchFields[i].BeforeFirst(':');
			codeTable=searchFields[i].AfterLast(':');
			if (codeTable=="transactionTypes") //cheap hack - I'm so lame - shoot me 
				// I should go on about how this doesn't belong on this database layer
				// but I'm just going to do it right now.
			{
			tStr.Printf(",if(xxx.%s is null,'Undecided',%s.description)",codeField,codeAlias,codeAlias);
			query.Append(tStr);
			tStr.Printf(" LEFT JOIN %s %s ON xxx.%s=%s.id",codeTable,codeAlias,codeField,codeAlias);
			fromStr.Append(tStr);
			tStr.Printf(" %s.description",codeAlias);
			whereStr.Append(tStr);
			} else {
			tStr.Printf(",if(xxx.%s is null,'',concat(%s.short,':',%s.full))",codeField,codeAlias,codeAlias);
			query.Append(tStr);
			tStr.Printf(" LEFT JOIN %s %s ON xxx.%s=%s.id",codeTable,codeAlias,codeField,codeAlias);
			fromStr.Append(tStr);
			tStr.Printf(" %s.full",codeAlias);
			whereStr.Append(tStr);
			}
//if is code, code.short:code.full
		} else {
		query.Append(",if(xxx.");
		query.Append(searchFields[i]);
		query.Append(" is not null,xxx.");
		query.Append(searchFields[i]);
		query.Append(",'')");

		whereStr.Append(" xxx.");
		whereStr.Append(searchFields[i]);
		}

		if (cCase->GetValue()) {
			if (cWhole->GetValue()) {
				whereStr.Append(" LIKE BINARY '");
				whereStr.Append(db->EscapeString(tSearch->GetValue().c_str()));
				whereStr.Append("'");
			} else {
				whereStr.Append(" LIKE BINARY '%");
				whereStr.Append(db->EscapeString(tSearch->GetValue().c_str()));
				whereStr.Append("%'");
			}
		} else	{
			if (cWhole->GetValue()) {
				whereStr.Append(" LIKE '");
				whereStr.Append(db->EscapeString(tSearch->GetValue().c_str()));
				whereStr.Append("'");
			} else {
				whereStr.Append(" LIKE '%");
				whereStr.Append(db->EscapeString(tSearch->GetValue().c_str()));
				whereStr.Append("%'");
			}
		}
		if (i<searchFields.GetCount()-1)
			{whereStr.Append(" OR ");}
	}
	query.Append(fromStr);
	query.Append(whereStr);
	//if order by column
	if (!sOrderBy.IsEmpty())
	{ 
	  query.Append(" ORDER BY xxx.");
	  query.Append(sOrderBy);
	}
//	wxMessageBox(query,"Debug",wxOK,this);
	//execute query
	prog->Update(1,"Asking Database");
	qry=db->Query((char *)query.c_str(),query.Length());
	delete prog;//	prog->Destroy();
Enable(TRUE);
	if (qry==NULL)
	{
		wxEndBusyCursor();
		if (db->IsError())
			{ LOG_ERROR(db->GetError()); }
		return; 
	}
	wxString name,label;
	unsigned long j=0;
	//	size_t j=0;
	unsigned long item;
	i=0;
	unsigned long max;
	max=db->FetchNumRows(qry);
	if (max > 1000)
	{
		tStr.Printf("There are %u results for your search.\nAre you sure you want to see them all ?\nIf not, press no and refine your search.\nUse the 'Whole Word' or 'Case Sensitive' options to get a closer match.",max);
//		if ((wxGetOsVersion()==wxWIN95) && (max > 6000))
//		{ tStr.Append("\n\nSearches over 6000 results are known to crash Windows 95/98 computers.\nIf your computer locks up, use Ctrl-Alt-Delete to end BOLT and recover."); }

		if (wxMessageBox(tStr,"Over 1000 results",wxYES_NO,this)==wxNO)
		{
			db->FreeQuery(qry);
			this->cancelSearch=false;
			wxEndBusyCursor();
			return;
		}
	}
	prog=new wxProgressDialog("Getting Information","Fetching Data",max,this,wxPD_CAN_ABORT|wxPD_REMAINING_TIME|wxPD_AUTO_HIDE);
	wxString progStr;
	//fill in results - set ItemData=recordID
	cancelSearch=false;
	while ((row=db->FetchRow(qry))&&(!this->cancelSearch))
	{
		j++;
		if ((j % PROG_STEP)==0) //update progress
		{
			progStr.Printf("Fetching %u to %u of %u",j,j+PROG_STEP-1,max);
			cancelSearch=!prog->Update(j,progStr);
		}
		if ((wxGetOsVersion()==wxWIN95) && (j > 999))
		{ 
			wxMessageBox("Only displaying the first 1000 results due to Windows 95/98 limitations.","Over 1000 results",wxOK,this);
			cancelSearch=true;
		}  //protect from that lame crash on win98

		name.Printf("%u",j);
		item=lResults->InsertItem(j,name);

		for (i=1; i<=searchFields.GetCount(); i++)
		{
			tmp=db->FetchQueryResult(qry,row,i);
			if (tmp)
			{
			label.Printf("%s",tmp);
			} else { label=""; };
			lResults->SetItem(item,i-1,label);
		}
//					lResults->SetItemText(item,c);
	}
	if (i>0)
	{
		lResults->SetFocus();
		unsigned long item;
		lResults->SetItemState(item=lResults->GetNextItem(-1,
                                     wxLIST_NEXT_ALL,
                                     wxLIST_STATE_DONTCARE),wxLIST_STATE_SELECTED|wxLIST_STATE_FOCUSED,wxLIST_STATE_SELECTED|wxLIST_STATE_FOCUSED);
		SetDefaultItem(bOpen);
	}
	else
	{ tSearch->SetFocus(); }
	delete prog;//	prog->Destroy();
	db->FreeQuery(qry);
	this->cancelSearch=false;
	wxEndBusyCursor();
	bOpen->Enable(lResults->GetItemCount()>0);
	bStart->Enable(FALSE);
};

void BOLTSearcher::OnBCancel(wxCommandEvent& event)
{ 	
	lResults->ClearAll();
	EndModal(0); 
};

void BOLTSearcher::OnBOpen(wxCommandEvent& event)
{
	RECORD_ID item;
	RECORD_ID res;
	if (lResults->GetSelectedItemCount()==1)
	{
	item=lResults->GetNextItem(-1,wxLIST_NEXT_ALL,wxLIST_STATE_SELECTED);
	wxString tStr;
	tStr=lResults->GetItemText(item);
	tStr.ToULong(&res);
//	res=lResults->GetItemData(item);
	lResults->ClearAll();
	EndModal(res);
	} else { wxBell(); }
};

void BOLTSearcher::OnCCase(wxCommandEvent& event)
{
	bStart->Enable(TRUE);
};

void BOLTSearcher::OnCWhole(wxCommandEvent& event) 
{
	bStart->Enable(TRUE);	
};

void BOLTSearcher::OnTSearch(wxCommandEvent& event)
{
	wxString tmp;
	tmp=tSearch->GetValue();
	bStart->Enable(tmp.Len()>0);
	bStart->SetDefault();
	tSearch->SetFocus();
}

void BOLTSearcher::OnColumn(wxListEvent &event)
{
	wxString tStr;
	if (event.GetColumn()==0)
	{ 
		tStr="id"; 
	} 
	else
	{
		tStr=this->searchFields[event.GetColumn()].BeforeFirst(':');
	}
//set order by column
	if (sOrderBy==tStr)
	{ sOrderBy.Append(" DESC"); }
	else
	{ this->sOrderBy=tStr; }

	DoSearch();
}

void BOLTSearcher::OnChar(wxKeyEvent &event)
{
	if (event.AltDown()&&(event.GetKeyCode()=='.'))
	{
		this->cancelSearch=true;
	}
	else { event.Skip(); }

}
